#include <algorithm>
#include <iostream>
#include <limits.h>
#include <vector>

// limit l = 10^18
// 2^59 < l < 2^60
// 8 bajtova
typedef long long int ShLong;

struct Dekart {
    int x;
    int y;
};

ShLong pitagora(Dekart o, Dekart a, Dekart b) {
    return (a.x - o.x) * (b.y - o.y) - (a.y - o.y) * (b.x - o.x);
}

bool compare(Dekart x, Dekart y) {
    if(x.x > y.x) return true;
    else return x.y > y.y;
}

std::vector<Dekart> konveksniOblik(std::vector<Dekart>& tacke) {

    std::sort(tacke.begin(),tacke.end(),compare);

    std::vector<Dekart> lower = tacke;

    for (Dekart p: lower) {
        while(lower.size() >= 2 && pitagora(lower[2], lower[1], p) <= 0)
            lower.pop_back();
        lower.push_back(p);
    }

    std::vector<Dekart> upper;
    std::vector<Dekart> reverse = tacke;
    std::sort(tacke.begin(),tacke.end(),!compare);

    for (Dekart p: reverse) {
        while(lower.size() >= 2 && pitagora(upper[2], upper[1], p) <= 0) {
            upper.pop_back();
        }
        upper.push_back(p);
    }

    lower.pop_back();
    upper.pop_back();

    lower.insert(lower.end(),upper.begin(),upper.end());
    return lower;
}

ShLong poligonP(std::vector<Dekart>& tacke, int N) {

    ShLong area = 0;

    for(int i = 0; i < N; i++) {

        Dekart d1 = tacke[i];
        Dekart d2 = tacke[(i+1) % N];
        area += d1.x*d2.y - d1.y*d2.x;
    }
    if(area < 0) return area / -2;
    else return area / 2;
}

int main() {

    int N;

    std::cin >> N;

    // Dekart *coords = new Dekart[N];
    std::vector<Dekart> coords;

    for(int i = 0; i < N; i++) {

        Dekart shlong{};
        std::cin >> shlong.x >> shlong.y;
        coords.push_back(shlong);
    }

    ShLong minArea = LLONG_MIN;

    for(int i = 0; i<N; i++) {

        std::vector<Dekart> removeElVector = coords;
        removeElVector.erase(removeElVector.begin()+i);

        removeElVector = konveksniOblik(removeElVector);

        ShLong area = poligonP(removeElVector, N);
        minArea = std::min(minArea,area);
    }

    std::cout << minArea <<std::endl;

    return 0;
}